/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.thonkutil.impl;

import com.jab125.thonkutil.api.AnimatedCapeItem;
import com.jab125.thonkutil.api.CapeItem;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class TextureLoader {
    public static void apply2WingedElytra(CapeItem cape) {
        try {
            InputStream texture = class_310.method_1551().method_1478().method_14486(cape.getElytraTexture0()).method_14482();
            class_1011 elytra = class_1011.method_4309((InputStream)texture);
            Int2ObjectOpenHashMap elytraTextures = new Int2ObjectOpenHashMap();
            int imageHeight = elytra.method_4323() / (elytra.method_4307() / 2);
            imageHeight = 2;
            for (int currentFrame = 0; currentFrame < imageHeight; ++currentFrame) {
                class_1011 frame = new class_1011(elytra.method_4307(), elytra.method_4307() / 2, true);
                for (int x = 0; x < frame.method_4307(); ++x) {
                    for (int y = 0; y < frame.method_4323(); ++y) {
                        frame.method_4305(x, y, elytra.method_4315(x, y + currentFrame * (elytra.method_4307() / 2)));
                    }
                }
                elytraTextures.put(currentFrame, (Object)frame);
            }
            TextureLoader.loadElytraFramesToResource((Int2ObjectMap<class_1011>)elytraTextures, cape.getRegistryIdAsIdentifier().method_36181());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void applyAnimatedCape(AnimatedCapeItem cape) {
        try {
            InputStream texture = class_310.method_1551().method_1478().method_14486(cape.getCapeTexture0()).method_14482();
            class_1011 capeImage = class_1011.method_4309((InputStream)texture);
            Int2ObjectOpenHashMap animatedCapeFrames = new Int2ObjectOpenHashMap();
            int imageHeight = capeImage.method_4323() / (capeImage.method_4307() / 2);
            for (int currentFrame = 0; currentFrame < imageHeight; ++currentFrame) {
                class_1011 frame = new class_1011(capeImage.method_4307(), capeImage.method_4307() / 2, true);
                for (int x = 0; x < frame.method_4307(); ++x) {
                    for (int y = 0; y < frame.method_4323(); ++y) {
                        frame.method_4305(x, y, capeImage.method_4315(x, y + currentFrame * (capeImage.method_4307() / 2)));
                    }
                }
                animatedCapeFrames.put(currentFrame, (Object)frame);
            }
            TextureLoader.loadFramesToResource((Int2ObjectMap<class_1011>)animatedCapeFrames, cape.getRegistryIdAsIdentifier().method_36181());
        }
        catch (IOException exception) {
            System.out.println("ERROR");
        }
    }

    private static void loadFramesToResource(Int2ObjectMap<class_1011> cape, String itemId) {
        cape.forEach((integer, nativeImage) -> {
            class_2960 identifier = new class_2960("thonkutil", String.format("capes/%s/%d", itemId, integer));
            TextureLoader.applyTexture(identifier, nativeImage);
        });
    }

    private static void loadElytraFramesToResource(Int2ObjectMap<class_1011> cape, String itemId) {
        cape.forEach((integer, nativeImage) -> {
            class_2960 identifier = new class_2960("thonkutil", String.format("elytra/%s/%d", itemId, integer));
            TextureLoader.applyTexture(identifier, nativeImage);
        });
    }

    private static void applyTexture(class_2960 identifier, class_1011 image) {
        class_310.method_1551().execute(() -> class_310.method_1551().method_1531().method_4616(identifier, (class_1044)new class_1043(image)));
    }
}

